# -*- coding:utf-8 -*-
from django.core.management.base import BaseCommand
ANDROID_SERVER_KEY = "AAAAIFvPA7I:APA91bHqm3JV2Z5119n0wF8JKgafbVMOnXGzC9DbqTCfHlERy3VHOkdbeOiZ-z3LriuSCdgPB4Alp3eWu7Zos8smnSkstIGprx38_0k69uWOQYL_O28FL31C6HKjvey-u2lDalTnLoWL"
__author__ = 'Arvin'
APN = None


def get_apn_connection():
    from apnsclient import APNs, Session
    global APN
    if not APN:
        session = Session()
        con = session.get_connection('push_production', cert_file='app_certificate/production.pem', passphrase='123456')
        srv = APNs(con)
        APN = srv
    return APN


def push2client(account, message):
    from mysite.iclock.models.model_applist import AppList, IOS, ANDROID
    apps = AppList.objects.filter(username=account, active=True, enable=True)
    print "[*]Apps:", apps
    if apps:
        app = apps[0]
        if app.client_category == IOS: #IOS
            from apnsclient import Message
            srv = get_apn_connection()
            msg = Message(tokens=app.device_token, alert=message, badge=1)
            res = srv.send(msg)
            print "[*]Push APNs:", message
            if res.errors:
                print u'{0}'.format(','.join(res.errors))
        elif app.client_category == ANDROID: #Android
            from pyfcm import FCMNotification
            push_service = FCMNotification(api_key=ANDROID_SERVER_KEY)
            title = "Notification"
            result = push_service.notify_single_device(registration_id=app.device_token, message_title=title, message_body=message)
            print "[*]Push FCM:", message


def push_notification(category, sub_category, notification, message):
    username = notification.get('receiver_pin', None)
    if username and message:
        push2client(username, message)


def get_email_content(category, notification, template, subject, content, head, cell):
    import re
    import json
    from django.utils.translation import get_language
    from mysite.att import constant, att_utils
    from base.models import EmailTemplate
    lng = get_language()
    event_status = content.get('approve_status')
    receiver_type = notification.get('role')
    ets = EmailTemplate.objects.filter(event=category, event_status=event_status, receiver=receiver_type, lng=lng)
    if ets:
        et = ets[0]
        subject = et.email_subject
        template = json.loads(et.email_content)
    else:
        subject = '{0} <{1}>'.format(subject, content.get('approve_describe', ''))
    _param = re.compile(r'{\w+}')
    m = re.findall(_param, template)
    head = dict(head)
    cell = dict(cell)
    receiver = dict(constant.RECEIVER_PARAMETER)
    for item in m:
        field = None
        data_dict = None
        if item in head:
            field = item
            data_dict = head
        elif item in cell:
            field = cell.get(item, None)
            data_dict = content
        elif item in receiver:
            field = receiver.get(item, None)
            data_dict = notification
        if field:
            func = None
            if field.find('|') != -1:
                field, func = field.split('|')
            val = u'{0}'.format(data_dict.get(field, ''))
            if func and callable(getattr(att_utils, func, None)):
                format_func = getattr(att_utils, func)
                val = format_func(val)
            template = template.replace(item, val)
    return subject, template


def email_notification(category, notification):
    from django.utils.translation import ugettext_lazy as _
    import json
    from mysite.att import constant
    from base.email_setting import push_email
    email = notification.get('receiver_email', '')
    print '[*]Notification:', notification
    if email:
        content = json.loads(notification['content'])
        subject = ''
        template = None
        if category in (constant.CATEGORY_LEAVE, ): #Leave
            subject = u'{0}'.format(_(u'请假'))
            head = constant.LEAVE_HEAD
            cell = constant.LEAVE_CELL
            template = constant.LEAVE_TEMPLATE
        elif category in (constant.CATEGORY_MANUAL, ): #Manual Punch
            subject = u'{0}'.format(_(u'补签卡'))
            head = constant.MANUAL_LOG_HEAD
            cell = constant.MANUAL_LOG_CELL
            template = constant.MANUAL_LOG_TEMPLATE
        elif category in (constant.CATEGORY_OVERTIME, ): #Overtime
            subject = u'{0}'.format(_(u'加班'))
            head = constant.OVERTIME_HEAD
            cell = constant.OVERTIME_CELL
            template = constant.OVERTIME_TEMPLATE
        elif category in (constant.CATEGORY_TRAINING, ): #Training
            subject = u'{0}'.format(_(u'培训'))
            head = constant.TRAINING_HEAD
            cell = constant.TRAINING_CELL
            template = constant.TRAINING_TEMPLATE
        elif category in (constant.CATEGORY_SCHEDULE, ): #Schedule
            subject = u'{0}'.format(_(u'调班'))
            head = constant.SCHEDULE_HEAD
            cell = constant.SCHEDULE_CELL
            template = constant.SCHEDULE_TEMPLATE
        if template is not None:
            subject, template = get_email_content(category, notification, template, subject, content, head, cell)
            data = {
                'subject': subject or '',
                'content': template,
            }
            push_email(subject, json.dumps(data), email, email_template='audit_email_template.html')


def sms_notification():
    pass


def window_pop(category, notification):
    """
    key: approval:pending
    """
    from ooredis import SortedSet
    from mysite.att import constant
    from mysite.utils import touch_sync
    if category in (constant.CATEGORY_MANUAL, constant.CATEGORY_LEAVE, constant.CATEGORY_OVERTIME, constant.CATEGORY_TRAINING, constant.CATEGORY_SCHEDULE):
        pending = SortedSet('approval:pending')
        val = '{0}|{1}'.format(category, notification['obj'])
        touch_sync(pending, val)


def save_notification(category, sub_category, receiver_id, sender, system_sender, content, obj, notification_time):
    import json
    from mysite.iclock.models.model_notification import Notification
    nfc = Notification()
    nfc.receiver_id = receiver_id
    nfc.sender = sender
    nfc.system_sender = system_sender
    nfc.category = category
    nfc.sub_category = sub_category
    nfc.content = json.dumps(content)
    nfc.notification_time = notification_time
    nfc.source = obj
    nfc.save()


def notification_handler(category, sub_category, notification, content, message):
    from mysite.utils import stamp2datetime
    receiver_id = notification['receiver_id']
    sender = notification['sender']
    system_sender = notification['system_sender']
    obj = notification['obj']
    notification_time = stamp2datetime(notification['now'])
    push_notification(category, sub_category, notification, message)
    save_notification(category, sub_category, receiver_id, sender, system_sender, content, obj, notification_time)


def app_notification(category, sub_category, notification):
    import json
    from mysite.att import constant
    from mysite.att.att_utils import stamp2datetime
    message = notification.get('message', '')
    content = json.loads(notification['content'])
    if category in (constant.CATEGORY_ATTENDANCE, ):
        start = content.get('start', None)
        end = content.get('end', None)
        if start and end:
            start = stamp2datetime(start)
            end = stamp2datetime(end)
            late_count = content.get('late_count', 0)
            early_count = content.get('early_count', 0)
            absent_count = content.get('absent_count', 0)
            if late_count > 0:
                content = message = 'You got {0} times late during {1} - {2}'.format(late_count, start.strftime("%Y-%m-%d"), end.strftime("%Y-%m-%d"))
                notification_handler(category, constant.SUB_CATEGORY_LATE, notification, content, message)
            if early_count > 0:
                content = message = 'You got {0} times early leave {0} during {1} - {2}'.format(early_count, start.strftime("%Y-%m-%d"), end.strftime("%Y-%m-%d"))
                notification_handler(category, constant.SUB_CATEGORY_EARLY_LEAVE, notification, content, message)
            if absent_count > 0:
                content = message = 'You got 0} times  absent during {1} - {2}'.format(absent_count, start.strftime("%Y-%m-%d"), end.strftime("%Y-%m-%d"))
                notification_handler(category, constant.SUB_CATEGORY_ABSENT, notification, content, message)
    else:
        notification_handler(category, sub_category, notification, content, message)


class Command(BaseCommand):
    option_list = BaseCommand.option_list + ()
    help = "Start Notification Service."
    args = ''

    def handle(self, *args, **options):
        """
        Redis Key: notification_queue(List)
        """
        from ooredis import List
        import time
        import json
        notification_queue = List('notification_queue')
        while True:
            if notification_queue:
                data_package = notification_queue.lpop()
                notification = json.loads(data_package)
                category = notification.get('category', None)
                sub_category = notification.get('sub_category', None)
                if category:
                    app_notification(category, sub_category, notification)
                    window_pop(category, notification)
                    email_notification(category, notification)
            time.sleep(0.01)
